# Introduction

See ["Obnam 3 acceptance criteri"](https://doc.obnam.org/obnam/obnam.html) for
an overview. This document is for the server only.


# Shared test files for verification scenarios

## Server configuration file

~~~{#server-config.yaml .file .yaml}
key_pair_file: keypair.json
listen: localhost:8000
~~~


# Acceptance criteria for the Obnam server


<!-- FIXME: fails under CI
## Reports its version

_Want:_ The server admin can query `obnam-server` for its version.

_Why:_ This helps Obnam developers when supporting remote users.

~~~scenario
given an installed obnam
when I run obnam-server --version
then stdout matches regex ^obnam-server v\d+\.\d+\.\d+
when I run obnam-server --version
then stdout matches regex ^obnam-server v\d+\.\d+\.\d+
~~~

-->

## Generates and validates API tokens

_Want:_ The server admin can generate an API token and validate it.

_Why:_ Users of the server need to the API token to make backups. The server
admin needs to be able to validate tokens for troubleshooting.

~~~scenario
given an installed obnam
given file server-config.yaml
when I run obnam-server --config server-config.yaml init
then file keypair.json exists
when I try to run obnam-server --config server-config.yaml init
then command fails
then stderr contains "keypair.json"
when I run obnam-server --config server-config.yaml token --output token.txt --allow append
then file token.txt contains "v4.public."
when I run obnam-server --config server-config.yaml validate --file token.txt
then stdout contains "read_chunks_allowed: true"
then stdout contains "find_chunks_allowed: true"
then stdout contains "create_chunk_allowed: true"
then stdout contains "delete_chunk_allowed: false"
when I run obnam-server --config server-config.yaml token --output token.txt --allow delete
then file token.txt contains "v4.public."
when I run obnam-server --config server-config.yaml validate --file token.txt
then stdout contains "read_chunks_allowed: true"
then stdout contains "find_chunks_allowed: true"
then stdout contains "create_chunk_allowed: true"
then stdout contains "delete_chunk_allowed: true"
~~~

## Refuses API token made for another server instance

_Want:_ An Obnam server should only accept API tokens for that server,
not tokens for another Obnam server instance.

_Why:_ Servers are distinct.

We simulate having different instances by re-initializing.

~~~scenario
given an installed obnam
given file server-config.yaml
when I run obnam-server --config server-config.yaml init
when I run obnam-server --config server-config.yaml token --output token.txt --allow append
when I remove file keypair.json
when I run obnam-server --config server-config.yaml init
when I try to run obnam-server --config server-config.yaml validate --file token.txt
then command fails
~~~

## Validates token via HTTP API

_Want:_ Obnam user can validate their API token with the `/validate` endpoint.

_Why:_ This helps them troubleshoot by making sure they have a valid token.


~~~scenario
given an installed obnam
given file server-config.yaml
given file request.sh
when I run obnam-server --config server-config.yaml init
when I run obnam-server --config server-config.yaml token --output token.txt --allow append
when I run, as a daemon, obnam-server --config server-config.yaml serve
when I run bash request.sh /validate
then stdout contains ""read_chunks_allowed":true"
then stdout contains ""find_chunks_allowed":true"
then stdout contains ""create_chunk_allowed":true"
then stdout contains ""delete_chunk_allowed":false"
~~~

~~~{#request.sh .file .bash}
set -xeuo pipefail

BASE="http://localhost:8000"
REST="$1"

curl -sv -H "Authorization: Bearer $(cat token.txt)" "$BASE$REST"
~~~
