# Getting started with Obnam

This is a very short explanation of how to get started using Obnam. The
commands below assume `obnam` has been installed on the `$PATH`, but you can
invoke it from the source tree using `cargo run` instead.

You need `rsop` installed for this.

## Configuration file

Create an OpenPGP key, and a configuration file that uses it as a credential.
Run `rsop generate-key alice@example.com > alice.key`. Then create
`~/.config/obnam/config.yaml` that looks like this:

~~~
store: mychunks
credentials:
  softy:
    openpgp-key: |
      PUT ALICE.KEY HERE
~~~

## Create a store and client

~~~
mkdir mychunks
obnam store init
obnam client init testy --credential softy
obnam chunk encrypt --label data --client-name testy --key-name default README.md --id first
cargo run -q -- --config config.yaml chunk decrypt --client-name testy --key-name default --id first
~~~

Note that Obnam only deals with individual chunks, for now. It does not split
files into chunks, nor remember what files belong in a backup.
